{* Calculate title from path *}
{capture name="title"}
   {if count($path) > 1} - {/if}
   {foreach from=$path item=category name=path}
      {if $smarty.foreach.path.iteration gt 2}
         >
      {/if}
      {if not $smarty.foreach.path.first}
         {$category.TITLE}
      {/if}
   {/foreach}
{/capture}
{strip}
{if $title_prefix}
   {assign var="in_page_title" value=$title_prefix|cat:$category.TITLE}
{else}
   {assign var="in_page_title" value=$category.TITLE}
{/if}
{assign var="description" value=$category.DESCRIPTION}

{include file="header.tpl"}
{include file="top_bar.tpl"}


{* Calculate the number of categories per row *}
   {php}
      $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / CATS_PER_ROW));
   {/php}
{if $cats_per_col > 15}
   {php}
      $this->assign('cats_per_col', ceil(count($this->get_template_vars('categs')) / (CATS_PER_ROW + 1)));
   {/php}
{/if}

	
{* Show category search results *}
{if $search_category}
   {$search_category}
{/if}

{* Show article search results *}
{if $search_article}
   {$search_article}
{/if}

{if isset($have_search_results) and $have_search_results == 0}
<div class="caption"><p></p><h2>Sorry, No result found!</h2></div>
<div class="lbox">
<strong>{l}No records found that match your keyword(s){/l}: "{$search|escape|wordwrap:200:"\n":true}"</strong><br /><br />
<strong>{l}Suggestions{/l}:</strong><br />
<ul>
<li>{l}Make sure all words are spelled correctly{/l}.</li>
<li>{l}Try different keywords{/l}.</li>
<li>{l}Try more general keywords{/l}.</li>
</ul>
</div>
<br />
{/if}





{* Categories *}
{if !empty($categs)}

{* Categories *}
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<tr>
{foreach from=$categs item=cat name=categs}
   {if ($smarty.foreach.categs.iteration mod $cats_per_col eq 1 and $cats_per_col gt 1) or $smarty.foreach.categs.first}<td valign="top">{/if}

{if $category.ID==0}
<table cellpadding="0" cellspacing="0" class="cattop">
  <tr>
    <td><img src="{$smarty.const.DOC_ROOT}/templates/{$smarty.const.USE_TEMPLATE}/images/cat.top.left.gif" alt="" /></td>
    <td width="100%"></td>
    <td><img src="{$smarty.const.DOC_ROOT}/templates/{$smarty.const.USE_TEMPLATE}/images/cat.top.right.gif" alt="" /></td>
  </tr>
</table>
<div class="bbg">
<div class="cat">
	<a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT}<span>({$cat.COUNT})</span>{/if}
</div>
{* Display subcategories *}
{if !empty($cat.SUBCATS)}
<div class="subcat">
{foreach from=$cat.SUBCATS item=scat name=scategs}
<p><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{$scat.TITLE_URL|escape}/{else}index.php?c={$scat.ID}{/if}">{$scat.TITLE|escape}</a></p>
{/foreach}
</div>
</div>

{/if}

{else}
<div class="catin">
	<p><a href="{if $smarty.const.ENABLE_REWRITE}{$cat.TITLE_URL|escape}/{else}index.php?c={$cat.ID}{/if}">{$cat.TITLE|escape}</a>{if $smarty.const.CATS_COUNT}<span>({$cat.COUNT})</span>{/if}</p>
</div>

{/if}


{if ($smarty.foreach.categs.iteration mod $cats_per_col eq 0 and $cats_per_col gt 1) or $smarty.foreach.categs.last}</td>{/if}
{/foreach}
</tr></table>

{/if}
{* Categories *}




{if $smarty.const.FTR_ENABLE == 1 and !empty($feat_links)}
<div class="fcaption"><p></p><h2>Featured Links</h2></div>
{foreach from=$feat_links item=link name=links}
<div class="fbox">{include file="f.link.tpl" link=$link}</div>
<br />
{/foreach}

<br />
{/if}

{* Links heading and sorting*}
{if ($uid || $search || !empty($category.ID) || $list) && !empty($links)}
<div class="caption"><p></p><h2>

	{if not $list}{l}<span class="sort">Sort by{/l}:
   {if $smarty.const.ENABLE_PAGERANK and $smarty.const.SHOW_PAGERANK}{if $sort eq 'P'} {l}PageRank{/l}{else} <a href="?s=P{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}"> {l}PageRank{/l}</a>{/if} |{/if}
   {if $sort eq 'H'} {l}Hits{/l}{else} <a href="?s=H{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}">{l}Hits{/l}</a>{/if}
   {if $sort eq 'A'} | {l}Alphabetical{/l}{else} | <a href="?s=A{if !empty($p)}&amp;p={$p}{/if}{if not $smarty.const.ENABLE_REWRITE}&amp;c={$category.ID}{/if}{if $search}&amp;search={$search}{/if}{if $uid}&amp;uid={$uid}{/if}">{l}Alphabetical{/l}</a>{/if}
   </span>{/if}

Standard Links</h2></div>


{foreach from=$links item=link name=links}
<div class="lbox">{include file="link.tpl" link=$link}</div>
{/foreach}

<br />
{/if}


{* Articles *}
{if !empty($articles) and !$uid and !$search}
<div class="fcaption"><p></p><h2>{l}Articles{/l}</h2></div>
{foreach from=$articles item=article name=name}
<div class="lbox">{include file="articlelink.tpl" link=$article}</div>
{/foreach}
{/if}




{* Javascript for tracking link clicks *}
{if $StopLinkHits eq 0}
   <script language="javascript" type="text/javascript">
   /* <![CDATA[ */
      var root = '{$smarty.const.DOC_ROOT}';
      {literal}
      var a = document.getElementsByTagName("a");
      for(i = 0; i< a.length; i++)
         if(a[i].id != '')
            a[i].onclick = count_link;
      function count_link() {
         i = new Image();
         i.src= root+'/cl.php?id='+this.id;
         return true;
      }
      {/literal}
   /* ]]> */
   </script>
{/if}

{include file="footer.tpl"}
{/strip}